import React from 'react';
import Login from './components/Login/Login';
import Scanner from './components/Scanner/Scanner';
import AddCouponValue from "./components/AddCouponValue/AddCouponValue";
import './App.css';
import {
    BrowserRouter as Router,
    useRoutes
} from "react-router-dom";

function RequireAuth() {
    const loginData = localStorage.getItem('loginData');
    const scanData = localStorage.getItem('scanData');
    if(!loginData) {
        return <Login/>;
    } else if (loginData && !scanData) {
        return <Scanner/>;
    } else if (loginData && scanData) {
        return <AddCouponValue/>;
    } else {
        return <Login/>;
    }
}

const AppRoutes = () => {
    let routes = useRoutes([
        { path: "/", element: <RequireAuth><Login /></RequireAuth> },
        { path: "/scanner", element: <RequireAuth><Scanner/></RequireAuth>  },
        { path: "/addcouponvalue", element: <RequireAuth><AddCouponValue/></RequireAuth>  },
    ]);
    return routes;
};

function App() {
    return (
        <div className="App h-100">
            <Router>
                <AppRoutes/>
            </Router>
        </div>
    );
}

export default App;