import React, { useState } from 'react';
import './AddCouponValue.css';
import axios from 'axios';
import { useNavigate } from "react-router-dom";

async function addValue(params) {
    const loginData = JSON.parse(localStorage.getItem('loginData'));
    const scanData = JSON.parse(localStorage.getItem('scanData'));
    const scanParams = new URLSearchParams(scanData);
    const companyId = loginData.companyId;
    const customerId = scanParams.get('customerId');
    var config = {
        method: 'post',
        url: 'https://adminapi.kroowd.com/?method=addCouponValue&apiKey=LIAzuq60iXGdzT3St599JQ&userName=zrinity7380&passWord=Y6t778T1iuo&couponValue='+params.couponValue+'&placeId='+companyId+'&couponUserId='+customerId,
        headers: { }
    };

    return axios(config)
        .then(function (response) {
            return response.data.Response[0];
        })
        .catch(function (error) {
            console.log(error);
        });
}

export default function AddCouponValue() {
    const [couponValue, setCouponValue] = useState();
    const [people, setPeople] = useState();
    const [scanType, setScanType] = useState();
    const [showMsg, showMessage] = useState();
    const navigate = useNavigate();

    const handleSubmit = async e => {
        e.preventDefault();
        const data = await addValue({
            couponValue,
            people,
            scanType
        });
        console.log(data);
        if(data.Status === "200") {
            localStorage.removeItem('scanData');
            navigate('/scanner');
        } else {
            showMessage(true)
        }
    };

    const cancelSubmit = async e => {
        e.preventDefault();
        localStorage.removeItem('scanData');
        navigate('/scanner');
    };

    function ShowMessage() {
        return <div className="message">Something went wrong!</div>;
    }

    return <div className="add-coupon-value h-100">
        <div className="page-header">
            Add Coupon Value
        </div>
        <div className="container h-100">
            <form onSubmit={handleSubmit} className="coupon-form">
                <div className="form-group">
                    <label><strong>What is the Receipt Total?</strong></label>
                    <input type="number" step="any" className="form-control" name="coupon_value" onFocus={() => showMessage(false)} onChange={e => setCouponValue(e.target.value)} />
                </div>
                <div className="form-group">
                    <label><strong>Number of People In Party?</strong></label>
                    <input type="number" className="form-control" name="number_of_people" onFocus={() => showMessage(false)} onChange={e => setPeople(e.target.value)} />
                </div>
                <div className="form-group">
                    <label><strong>Dine Type:</strong></label>
                    <select className="form-control" name="scan_type" onFocus={() => showMessage(false)} onChange={e => setScanType(e.target.value)}>
                        <option></option>
                        <option>Dine In</option>
                        <option>Pick Up</option>
                        <option>Delivery</option>
                    </select>
                </div>
                <hr />
                <button type="submit" className="btn btn-black btn-login">Submit</button>
                <button className="btn btn-black btn-cancel" onClick={cancelSubmit}>Cancel</button>
                { showMsg ? <ShowMessage /> : null }
            </form>
        </div>
    </div>;
}