import React, {useState} from 'react';
import QrReader from 'react-qr-reader'
import { useNavigate } from "react-router-dom";

import './Scanner.css';

export default function Scanner() {
    const navigate = useNavigate();
    const [showMsg, showMessage] = useState();

    const handleScan = data => {
        if(data !== null) {
            const scanParams = new URLSearchParams(data);
            const customerId = scanParams.get('customerId');
            const couponId = scanParams.get('couponId');
            const companyId = scanParams.get('companyId');
            if (customerId && couponId && companyId) {
                localStorage.setItem('scanData', JSON.stringify(data));
                navigate('/addcouponvalue');
            } else {
                showMessage(true);
            }
        }
    };
    const handleError = err => {
        console.error(err)
    };

    function ShowMessage() {
        return <div className="message">Invalid QR Code!</div>;
    }

    return <div className="scanner h-100">
            <div className="page-header">
                Scan Barcode
            </div>
        { showMsg ? <ShowMessage /> : null }
            <div className="container h-100">
                <QrReader
                    delay={300}
                    onError={handleError}
                    onScan={handleScan}
                    style={{ width: '100%' }}
                    className="scanner-inner"
                />
            </div>
        </div>
}