import React from 'react';
import Login from './components/Login/Login';
import Redeem from './components/Redeem/Redeem';
import AddCouponValue from "./components/AddCouponValue/AddCouponValue";
import './App.css';
import {
    BrowserRouter as Router,
    useRoutes
} from "react-router-dom";

function RequireAuth() {
    const loginData = localStorage.getItem('loginData');
    const redeemData = localStorage.getItem('redeemData');
    if(!loginData) {
        return <Login/>;
    } else if (loginData && !redeemData) {
        return <Redeem/>;
    } else if (loginData && redeemData) {
        return <AddCouponValue/>;
    } else {
        return <Login/>;
    }
}

const AppRoutes = () => {
    let routes = useRoutes([
        { path: "/", element: <RequireAuth><Login /></RequireAuth> },
        { path: "/redeem-offers", element: <RequireAuth><Redeem/></RequireAuth>  },
        { path: "/addcouponvalue", element: <RequireAuth><AddCouponValue/></RequireAuth>  },
    ]);
    return routes;
};

function App() {
    return (
        <div className="App h-100">
            <Router>
                <AppRoutes/>
            </Router>
        </div>
    );
}

export default App;