import React, { useState } from 'react';
import axios from 'axios';

import './Login.css';
import { useNavigate } from "react-router-dom";

async function loginUser(credentials) {
    var config = {
        method: 'post',
        url: 'https://adminapi.kroowd.com/?method=adminLogin&apiKey=LIAzuq60iXGdzT3St599JQ&userName=zrinity7380&passWord=Y6t778T1iuo&merchantEmailAddress='+credentials.userName+'&merchantPassWord='+credentials.password,
        headers: { }
    };

    return axios(config)
        .then(function (response) {
            return response.data.Response[0];
        })
        .catch(function (error) {
            console.log(error);
        });
}

export default function Login() {
    const [userName, setUserName] = useState();
    const [password, setPassword] = useState();
    const [showMsg, showMessage] = useState();
    const navigate = useNavigate();

    const handleSubmit = async e => {
        e.preventDefault();
        const data = await loginUser({
            userName,
            password
        });
        if(data.Status === "200") {
            localStorage.setItem('loginData', JSON.stringify(data));
            navigate('/redeem-offers');
        } else {
            showMessage(true)
        }
    };

    function ShowMessage() {
        return <div className="message">Username or password is incorrect!</div>;
    }

    return <div className="login h-100">
        <div className="page-header">
            Login
        </div>
        <div className="container h-100">
            <form onSubmit={handleSubmit} className="login-form">
                <div className="form-group">
                    <label><strong>Email Address:</strong></label>
                    <input type="email" className="form-control" name="email" onFocus={() => showMessage(false)} onChange={e => setUserName(e.target.value)} />
                </div>
                <div className="form-group">
                    <label><strong>Password:</strong></label>
                    <input type="password" className="form-control" name="password" onFocus={() => showMessage(false)} onChange={e => setPassword(e.target.value)} />
                </div>
                <hr />
                <button type="submit" className="btn btn-black btn-login">Login</button>
                { showMsg ? <ShowMessage /> : null }
            </form>
            <div className="install-instructions">
                <h4>Install Instructions:</h4>
                <strong>Chrome:</strong><br/>
                1. On your computer, open Chrome. At the top right of the address bar, click Install.
                2. Follow the onscreen instructions to install the PWA.
                <br/><br/>
                <strong>Safari:</strong><br/>
                Tap the ‘Share’ button, scroll down and tap ‘Add to Home Screen.’ Enter the name for the app then tap add. The PWA will show up on your home screen like a native iOS app.
            </div>
        </div>
    </div>;
}