import React, {useState, useEffect} from 'react';
import { useNavigate, Link } from "react-router-dom";

import './Redeem.css';
import axios from "axios";

export default function Redeem() {
    const navigate = useNavigate();
    const [loading, setLoading] = useState(true);
    const [offers, redeemOffers] = useState();

    useEffect(() => {
        const getRedeemOffers = async () => {
            setLoading(true);
            const loginData = JSON.parse(localStorage.getItem('loginData'));
            const companyId = loginData.companyId;
            var config = {
                method: 'get',
                url: 'https://adminapi.kroowd.com/?method=getRedeemPush&apiKey=LIAzuq60iXGdzT3St599JQ&userName=zrinity7380&passWord=Y6t778T1iuo&placeId='+companyId,
                headers: { }
            };

            const response = await axios.get(config.url);
            if(response.status === 200) {
                redeemOffers(response.data.Response);
            }
            setLoading(false);
            // return axios(config)
            //     .then(function (response) {
            //         if(response.status === 200) {
            //             redeemOffers(response.data.Response);
            //         } else {
            //             showMessage(true);
            //         }
            //     })
            //     .catch(function (error) {
            //         console.log(error);
            //     });
        };
        getRedeemOffers();
    }, []);
    // const handleScan = data => {
    //     if(data !== null) {
    //         const scanParams = new URLSearchParams(data);
    //         const customerId = scanParams.get('customerId');
    //         const couponId = scanParams.get('couponId');
    //         const companyId = scanParams.get('companyId');
    //         if (customerId && couponId && companyId) {
    //             localStorage.setItem('redeemData', JSON.stringify(data));
    //             navigate('/addcouponvalue');
    //         } else {
    //             showMessage(true);
    //         }
    //     }
    // };

    const setOfferData = async e => {
        e.preventDefault();
        const redeemId = e.target.getAttribute("data-redeem-id");
        localStorage.setItem('redeemData', JSON.stringify(redeemId));
        navigate('/addcouponvalue');
    };

    return <div className="redeem h-100">
        <div className="page-header">
            Redeem Offer
        </div>
        <div className="container h-100">
            <div className="redeem-inner">
                { loading ? 'Loading...' : offers.map(offer => (
                    <div className="offer" key={offer.offerId}>
                        <div className="redeem-image"><img src={offer.photo} alt="" /></div>
                        <div className="redeem-text">
                            <div className="redeem-name"><h3>{offer.firstName} {offer.lastName}</h3></div>
                            <div className="redeem-visit"><strong>Last Visit:</strong> {offer.lastStoreVisit ? offer.lastStoreVisit : '-'}</div>
                            <div className="redeem-amount"><strong>Spend:</strong> {offer.totalMoneySpent}</div>
                            <div className="redeem-offer">{offer.offer}</div>
                        </div>
                        <div className="redeem-offer-button"><Link className="redeem-offer-btn" to="/addcouponvalue" onClick={setOfferData} data-redeem-id={offer.redeemId}>Redeem Offer</Link></div>
                    </div>
                )) }
            </div>
        </div>
    </div>
}